<?php
session_start();
require_once 'config/database.php';

if (!isset($_SESSION['user_id'])) {
  header('Location: identification.php');
  exit();
}
$current_user_name = $_SESSION['user_name'] ?? 'Utilisateur';
$current_user_handle = isset($_SESSION['user_name']) ? '@' . strtolower(str_replace(' ', '', $_SESSION['user_name'])) : '@utilisateur';

?>

<!DOCTYPE html>
<html lang="fr">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Nouvel Acte - Mes Amis</title>
  <link rel="stylesheet" href="assets/css/style.css">
</head>
<body>
  <div class="container">
      <?php include 'includes/sidebar.php'; ?>

      <header class="header">
          <div class="search-box-container"><h1>Mes Amis</h1></div>
          <div class="actions">
              <div class="icon-btn notification-btn" title="Notifications"></div>
          </div>
      </header>

      <main class="main friends-page">
          <div class="friends-content-area">
              <section class="user-search-section">
                  <h2>Rechercher des utilisateurs</h2>
                  <div class="search-box friends-search-box">
                      <input type="text" id="userSearchInput" placeholder="Nom ou e-mail...">
                      <button id="userSearchButton" class="btn-search-friends">Rechercher</button>
                  </div>
                  <div id="userSearchResults" class="user-search-results">
                      <!-- Les résultats de la recherche s'affichent ici -->
                  </div>
              </section>

              <section class="pending-requests-section">
                  <h2>Demandes d'ami en attente</h2>
                  <div id="pendingRequestsList" class="friends-list">
                      <!-- Les demandes en attente s'affichent ici -->
                  </div>
              </section>

              <section class="current-friends-section">
                  <h2>Ma liste d'amis</h2>
                  <div id="currentFriendsList" class="friends-list">
                      <!-- La liste d'amis s'affiche ici -->
                  </div>
              </section>
          </div>
      </main>

      <aside class="aside">
          <div class="profile">
              <img src="assets/images/avatar-placeholder.jpg" alt="Avatar"/>
              <div class="info">
                  <div><?php echo htmlspecialchars($current_user_name); ?></div>
                  <div><?php echo htmlspecialchars($current_user_handle); ?></div>
              </div>
          </div>
          <!-- Autres éléments de la sidebar droite si nécessaire -->
      </aside>
  </div>

  <script src="assets/js/amis.js"></script>
  <script src="assets/js/main.js"></script> <!-- Pour showNotification -->
</body>
</html>
